/* Pulses */

var Pulses = [];
function Pulse(turret)
{
	this.x = turret.x;
	this.y = turret.y;
	this.r = 0;
	this.max_r = turret.range;
	this.atk = turret.atk;
	this.rate = turret.rate/2;
	this.owner = turret;
	this.time = GetTime();
	this.targets = [];
	this.onEnd = function(){};
}

Pulse.prototype.update = function()
{
	if (this.time + this.rate > GetTime())
	{
		this.r = (GetTime() - this.time) * this.max_r / this.rate;
		FilledCircle(MapToScreenX(0, this.x), MapToScreenY(0, this.y), this.r, T_Blue);
	}
	else { this.damageTargets(); this.onEnd(); }
}

Pulse.prototype.damageTargets = function()
{
	var i = this.targets.length;
	while(i--)
	{
		var target = this.targets[i];
		if (target.dead) continue;
		
		target.hp -= this.atk;
		if (target.hp <= 0)
		{
			target.dead = true;
			Game.money += target.money;
			Enemies.splice(Enemies.indexOf(target), 1);
			this.owner.kills++;
			Game.mana++;
		}
	}
}

function CreatePulse(turret)
{
	var pulse = new Pulse(turret);
	var targets = GetClosestEnemy(turret.x, turret.y, turret.range, 3);
	if (!targets) return;
	pulse.targets = (targets == null) ? [] : targets;
	pulse.onEnd = function() { Pulses.splice(Pulses.indexOf(this), 1); }
	Pulses.push(pulse);
}

function UpdatePulses()
{
	var i = Pulses.length;
	while(i--) { Pulses[i].update(); }
}